#ifndef DIAGS__NORTHBRIDGE_H__LOADED
#define DIAGS__NORTHBRIDGE_H__LOADED
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* Standard Access mechanisms for the regions of the system address map */


#include "lib.h"


/*--------------------------------------------------------------------*/
/* Machine configuration data */

/* number of independent PCI bus trees */
extern const unsigned char nb_pci_hosecount;		


/*--------------------------------------------------------------------*/
/* Low level access mechanisms */

extern void outportb(ui p , ui d);
extern void outportw(ui p , ui d);
extern void outportl(ui p , ui d);
extern void outportq(ui p , ul d);

extern ui inportb(ui p);
extern ui inportw(ui p);
extern ui inportl(ui p);
extern ul inportq(ui p);

extern void pcicfgwb(ui bus , ui dev , ui func , ui reg , ui data);
extern void pcicfgww(ui bus , ui dev , ui func , ui reg , ui data);
extern void pcicfgwl(ui bus , ui dev , ui func , ui reg , ui data);

extern ui pcicfgrb(ui bus , ui dev , ui func , ui reg);
extern ui pcicfgrw(ui bus , ui dev , ui func , ui reg);
extern ui pcicfgrl(ui bus , ui dev , ui func , ui reg);

extern void outmemb(ui p , ui d);
extern void outmemw(ui p , ui d);
extern void outmeml(ui p , ui d);
extern void outmemq(ui p , ul d);

extern ui inmemb(ui p);
extern ui inmemw(ui p);
extern ui inmeml(ui p);
extern ul inmemq(ui p);

extern ui inIack(void );
extern ul IOPCIClearNODEV( void );


extern void outled( unsigned );			/* diagnostic data */



/*--------------------------------------------------------------------*/
/* Fixups of the Northbridge that aren't covered by the normal init path */

extern void nb_setup( void );
extern void nb_fixup( void );


/* enable ECC reporting, correction in the Northbridge - 1=enable, 0=disable */
extern void nb_ecc( unsigned );
extern int nb_eccstat( char *buf );		/* 0 if OK, -1 if error occurred */


/*----------------------------------------------------------------------*/
/* SMP functionality */

extern unsigned nb_whami( void );	/* my CPU ID, starting from 0 */


#endif			/*  DIAGS__NORTHBRIDGE_H__LOADED  */
